﻿<%@ Page Title="" Language="C#" MasterPageFile="~/TBI_Instruments/RegistryInstrument.master" AutoEventWireup="true" CodeFile="PainOutcomes_Intake.aspx.cs" Inherits="TBI_Instruments_PainOutcomes_Intake" %>


<%@ Import Namespace="VeteransAffairs.Registries.Business" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>
<%@ Register TagPrefix="VA" TagName="TbiDiagnosisSelector" Src="~/controls/TbiDiagnosisSelector.ascx" %>



<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="Server">
    <link type="text/css" href="~/styles/StyleSheet.css" />
    <style type="text/css">
        .breadcrumbInstrument
        {
            background-color: #6B1424;
            border-bottom: 1px solid #000;
            color: #FFF;
            font-family: Verdana, Geneva, Arial, Helvetica, sans-serif;
            font-variant: small-caps;
            font-weight: 700;
            letter-spacing: 1px;
            margin: 2px 0 2px 0;
            padding: 8px 25px 5px 10px;
        }
        .detailTable
        {
            border: 0px;
            background-color: #FFFFFF;
        }
        .detailTable td
        {
            border: 0px;
            background-color: #FFFFFF;
        }
        .requiredField 
        {
        	font-weight:bold;
        	color:#FF0000;
        }
    </style>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" runat="Server">
    <asp:ScriptManager ID="ScriptManager1" ScriptMode="Release" runat="server">
    </asp:ScriptManager>
    <telerik:RadCodeBlock runat="server" ID="RadCodeBlock1">

        <script type="text/javascript">
            Sys.WebForms.PageRequestManager.getInstance().add_beginRequest(startRequest);
            Sys.WebForms.PageRequestManager.getInstance().add_endRequest(endRequest);

            function startRequest(sender, e) {
                //disable button during the AJAX call
                document.getElementById('<%=btnSaveSurveyDraft.ClientID%>').disabled = true;
                document.getElementById('<%=btnSubmitSurvey.ClientID%>').disabled = true;
                document.getElementById('<%=btnCancelSurvey.ClientID%>').disabled = true;
            }
            function endRequest(sender, e) {
                //re-enable button once the AJAX call has completed
                document.getElementById('<%=btnSaveSurveyDraft.ClientID%>').disabled = false;
                document.getElementById('<%=btnSubmitSurvey.ClientID%>').disabled = false;
                document.getElementById('<%=btnCancelSurvey.ClientID%>').disabled = false;
            }
        </script>
        <script type="text/javascript">
            $(document).ready(function() {

                // Disables 'Enter' Key from posting back on any input 
                // element ( textbox, radiolist, checkbox, etc )
                $('input').keydown(function(e) {
                    if (e.keyCode == 13) { return false; }
                });

                // Disables 'Enter' Key from posting back when no input 
                // element is in focus, and the enter key is pressed 
                $('div').keydown(function(e) {
                    if (e.keyCode == 13) { return false; }
                });

            }); // END $(document).ready(function()
        </script>
        <script type="text/javascript">
            $(document).ready(function() {
                $('input:text').keydown(function(e) {
                    //cancel enter to prevent errors
                    if (e.keyCode == 13)
                        return false;
                });

                //processPersonReporting_Click();
                //processRadioButtonQ_Click();

                window.onbeforeunload = function() {
                    //Save draft if timeout occurs
                    document.getElementById('<%= btnSaveSurveyDraft.ClientID %>').click();
                    // return;
                }

            }); // END $(document).ready(function()

        </script>

    </telerik:RadCodeBlock>
    <telerik:RadCodeBlock runat="server" ID="RadCodeBlock2">
        <div class="breadcrumbInstrument">
            <asp:Label ID="LabelBreadCrumb" runat="server" Text="TBI Instruments > Instrument Associations > Pain Outcomes Questionnaire VA Long Form - Intake"></asp:Label>
        </div>
    </telerik:RadCodeBlock>
    <telerik:RadCodeBlock runat="server" ID="RadCodeBlock3">
        <asp:UpdatePanel ID="MainUpdatePanel" runat="server">
            <ContentTemplate>
                <asp:UpdateProgress ID="MainUpdateProgress" runat="server">
                    <ProgressTemplate>
                        <!-- Modal Popup for Loading -->
                        <div style="padding-left: 3px;">
                            <div style="background-color: #FF0000; width: 170px; color: #FFFFFF; padding: 5px;">
                                Processing...Please wait.
                            </div>
                        </div>
                        <%--<div style="background-color: Gray; filter: alpha(opacity=50); opacity: 0.50; width: 100%; top: 0px; left: 0px; position: fixed;
                            height: 100%;">
                        </div>
                        <div style="margin: auto; font-family: Trebuchet MS; filter: alpha(opacity=100); opacity: 1; font-size: small; vertical-align: middle;
                            top: 45%; position: fixed; right: 45%; color: #232323; text-align: center; background-color: White; height: 100px;">
                            <table style="background-color: White; font-family: Sans-Serif; text-align: center; border: solid 1px #232323; color: #232323;
                                width: 300px; height: inherit; padding: 15px;">
                                <tr>
                                    <td style="text-align: inherit;">
                                        <img src="images/loading_image.gif" alt="Loading" title="Loading Image" />
                                    </td>
                                    <td style="text-align: inherit;">
                                        <span style="font-family: Sans-Serif; font-size: medium; font-weight: bold; font">Processing...Please wait.</span>
                                    </td>
                                </tr>
                            </table>
                        </div>--%>
                        <!-- End Modal Popup for Loading -->
                    </ProgressTemplate>
                </asp:UpdateProgress>
                <asp:ValidationSummary ID="TBIInstrumentsValidationSummaryOnSave" runat="server" TabIndex="1" HeaderText="The page has the following data errors:"
                    DisplayMode="BulletList" ShowSummary="false" ShowMessageBox="true" ValidationGroup="OnSave" />
                <asp:Panel ID="PanelPatient" Width="100%" GroupingText="&nbsp;&nbsp;Patient&nbsp;&nbsp;" runat="server">
                    <table cellpadding="5" cellspacing="5">
                        <tr>
                            <td>
                                &nbsp;&nbsp;<asp:Label ID="LabelForName" runat="server" Text="Patient:" AssociatedControlID="LabelPatient"></asp:Label>&nbsp;<asp:Label
                                    ID="LabelPatient" runat="server" SkinID="DataLabel" TabIndex="2"></asp:Label>
                            </td>
                            <td>
                                <asp:Label ID="LabelForSSN" runat="server" SkinID="DataLabel" AssociatedControlID="LabelSSN" Text="SSN:"></asp:Label>
                                &nbsp;<asp:Label ID="LabelSSN" runat="server" SkinID="DataLabel" TabIndex="3"></asp:Label>
                            </td>
                            <td>
                                <asp:Label ID="LabelForFacility" runat="server" SkinID="DataLabel" AssociatedControlID="LabelFacility" Text="Facility:" Visible="false"></asp:Label>
                                &nbsp;<asp:Label ID="LabelFacility" runat="server" SkinID="DataLabel" TabIndex="4"></asp:Label>
                            </td>
                        </tr>
                    </table>
                </asp:Panel>
                <!-- Hidden Field - Survey Type -->
                <asp:HiddenField ID="HiddenSurveyType" runat="server" Visible="false" Value="POQI" />
                <asp:Panel ID="PanelSurveyHeader" Width="100%" runat="server" CssClass="mainContent">
                    <br />
                    <asp:Label ID="LabelInstrumentTitle" runat="server" Style="font-weight: bold" /><!--&nbsp;-&nbsp;-->
                    <asp:LinkButton ID="lnkBtnToggleInstructions" runat="server" Text="Click for Instructions" ToolTip="Click to show/hide instructions."
                        OnClick="lnkBtnToggleInstructions_OnClick" TabIndex="5" Visible="false" Enabled="false" />
                    <br />
                </asp:Panel>
                <!-- Instruction Area -->
                <asp:Panel ID="PanelInstructions" runat="server" Visible="false">
                    <br />
                    <div style="padding: 5px; width: 900px;">
                    </div>
                </asp:Panel>
                <!-- End Instruction Area -->
                
                <br />
                <asp:Panel ID="PanelQuestions" Width="100%" runat="server" CssClass="mainContent">
                    <!-- Question Area -->                    
                    <table style="width:800px; margin-left:20px;">
                        <tr>
                            <td style="width: 20px;">
                                &nbsp;
                            </td>
                            <td>
                                <!-- Diagnosis Control -->
                                <!-- Set Question Text, SurveyTypeId, SurveyTypeCode in the page_load -->
                                <VA:TbiDiagnosisSelector ID="ctrlDiagnosis" runat="server" QuestionNumber="DX" StartTabIndex="6" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                &nbsp;
                            </td>
                            <td>
                                <%--<!--Date-->
                                <!-- Get text in code-behind -->                                
                                <asp:Label ID="LabelDate1" runat="server" AssociatedControlID="dpDate1" SkinID="DataLabel" TabIndex="10">
                                </asp:Label> <span class="requiredField">*</span>                                
                                <!--Date picker-->
                                <telerik:RadDatePicker ID="dpDate1" runat="server" TabIndex="11">
                                    <Calendar ID="calDate1" runat="server">
                                    </Calendar>
                                </telerik:RadDatePicker>
                                <!--Date 1 required field validator (only one required)-->
                                <br />
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorDate1" runat="server" ControlToValidate="dpDate1" TabIndex="12" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Date is required."></asp:RequiredFieldValidator>--%>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                1
                            </td>
                            <td>
                                <!--Date-->
                                <!-- Get text in code-behind -->                                
                                <asp:Label ID="LabelForQ1" runat="server" AssociatedControlID="dpDateQ1" SkinID="DataLabel" TabIndex="15">
                                </asp:Label> <span class="requiredField">*</span>                                
                                <!--Date picker-->
                                <telerik:RadDatePicker ID="dpDateQ1" runat="server" TabIndex="16">
                                    <Calendar ID="calDateQ1" runat="server">
                                    </Calendar>
                                </telerik:RadDatePicker>
                                <br />
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorDateQ1" runat="server" ControlToValidate="dpDateQ1" TabIndex="17" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Date is required."></asp:RequiredFieldValidator>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                2
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ2" runat="server" AssociatedControlID="txtQ2" SkinID="DataLabel" TabIndex="18"></asp:Label>
                                <span class="requiredField">*</span><br />
                                <asp:TextBox ID="txtQ2" runat="server" MaxLength="1000" Width="25px" TabIndex="19"></asp:TextBox>&nbsp;years
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ2" runat="server" ControlToValidate="txtQ2" TabIndex="20" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:RangeValidator ID="RangeValidatorForQ2" runat="server" TabIndex="21" ControlToValidate="txtQ2" ErrorMessage="Must be a positive integer."
                                MaximumValue="119" MinimumValue="1" SetFocusOnError="true" ValidationGroup="OnSave" Type="Integer" Display="Dynamic"></asp:RangeValidator>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                3
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ3" runat="server" AssociatedControlID="rblQ3" SkinID="DataLabel" TabIndex="22">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ3" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ3" TabIndex="23"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ3" runat="server" ControlToValidate="rblQ3" TabIndex="24" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ3" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ3" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ3" runat="server" Visible="false" Value="3" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                4
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ4" runat="server" AssociatedControlID="rblQ4" SkinID="DataLabel" TabIndex="26">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ4" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ4" TabIndex="27"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ4" runat="server" ControlToValidate="rblQ4" TabIndex="28" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ4" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ4" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ4" runat="server" Visible="false" Value="4" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                5
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ5" runat="server" AssociatedControlID="rblQ5" SkinID="DataLabel" TabIndex="30">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ5" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ5" TabIndex="31"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ5" runat="server" ControlToValidate="rblQ5" TabIndex="32" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ5" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ5" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ5" runat="server" Visible="false" Value="5" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>                            
                        <tr>
                            <td>
                                6
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ6" runat="server" AssociatedControlID="rblQ6" SkinID="DataLabel" TabIndex="33">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ6" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ6" TabIndex="34"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ6" runat="server" ControlToValidate="rblQ6" TabIndex="35" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ6" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ6" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ6" runat="server" Visible="false" Value="6" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                7
                            </td>
                            <td>

                                <asp:Label ID="LabelForQ7" runat="server" AssociatedControlID="txtQ7" SkinID="DataLabel" TabIndex="36"></asp:Label>
                                <span class="requiredField">*</span><br />
                                <asp:TextBox ID="txtQ7" runat="server" MaxLength="2" Width="25px" TabIndex="37"></asp:TextBox>&nbsp;years.
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ7" runat="server" ControlToValidate="txtQ7" TabIndex="38" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:RangeValidator ID="RangeValidatorForQ7" runat="server" TabIndex="39" ControlToValidate="txtQ7" ErrorMessage="Must be zero or a positive integer."
                                MaximumValue="99" MinimumValue="0" SetFocusOnError="true" ValidationGroup="OnSave" Type="Integer" Display="Dynamic"></asp:RangeValidator>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                8
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ8" runat="server" AssociatedControlID="chbxlstQ8" SkinID="DataLabel" TabIndex="40">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <asp:CheckBoxList ID="chbxlstQ8" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ8" TabIndex="41" OnDataBound="onChbxlstQ8DataBound"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:CheckBoxList>
                                <%--<asp:RequiredFieldValidator ID="RequiredFieldValidatorQ8" runat="server" ControlToValidate="chbxlstQ8" TabIndex="42" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>--%>
                                <asp:Label ID="lblErrorQ8" runat="server" CssClass="requiredField" TabIndex="42"></asp:Label>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ8" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ8" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ8" runat="server" Visible="false" Value="8" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr> 
                        <tr>
                            <td>
                                9
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ9" runat="server" AssociatedControlID="rblQ9" SkinID="DataLabel" TabIndex="61">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ9" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ9" TabIndex="62"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ9" runat="server" ControlToValidate="rblQ9" TabIndex="63" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ9" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ9" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ9" runat="server" Visible="false" Value="9" />
                            </td>
                        </tr> 
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                10
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ10" runat="server" AssociatedControlID="chbxlstQ10" SkinID="DataLabel" TabIndex="64">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <asp:CheckBoxList ID="chbxlstQ10" runat="server" RepeatColumns="3" RepeatDirection="Vertical" Width="450px" DataSourceID="ObjectDataSourceQ10" TabIndex="65" OnDataBound="onChbxlstQ10DataBound"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:CheckBoxList>
                                <%--<asp:RequiredFieldValidator ID="RequiredFieldValidatorQ10" runat="server" ControlToValidate="rblQ10" TabIndex="66" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>--%>
                                <asp:Label ID="lblErrorQ10" runat="server" CssClass="requiredField" TabIndex="66"></asp:Label>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ10" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ10" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ10" runat="server" Visible="false" Value="10" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                11
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ11" runat="server" AssociatedControlID="rblQ11" SkinID="DataLabel" TabIndex="67"></asp:Label> 
                                <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ11" runat="server" RepeatColumns="3" RepeatDirection="Vertical" Width="450px" DataSourceID="ObjectDataSourceQ11" TabIndex="68"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ11" runat="server" ControlToValidate="rblQ11" TabIndex="69" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ11" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ11" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ11" runat="server" Visible="false" Value="11" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                12
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ12" runat="server" AssociatedControlID="rblQ12" SkinID="DataLabel" TabIndex="75">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ12" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ12" TabIndex="76"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ12" runat="server" ControlToValidate="rblQ12" TabIndex="77" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ12" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ12" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ12" runat="server" Visible="false" Value="12" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                13
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ13" runat="server" AssociatedControlID="rblQ13" SkinID="DataLabel" TabIndex="81">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ13" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ13" TabIndex="82"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ13" runat="server" ControlToValidate="rblQ13" TabIndex="83" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ13" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ13" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ13" runat="server" Visible="false" Value="13" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                14
                            </td>
                            <td>

                                <asp:Label ID="LabelForQ14" runat="server" SkinID="DataLabel" Font-Bold="true" TabIndex="84">
                                </asp:Label>
                                <br />
                                <asp:TextBox ID="txtQ14_1" runat="server" Text="0" MaxLength="2" Width="25px" Font-Bold="true" TabIndex="85"></asp:TextBox>&nbsp;years&nbsp;&nbsp;&nbsp;&nbsp;
                                <asp:RangeValidator ID="RangeValidatorForQ14_1" runat="server" TabIndex="86" ControlToValidate="txtQ14_1" ErrorMessage="Must be zero or a positive integer."
                                MaximumValue="99" MinimumValue="0" SetFocusOnError="true" ValidationGroup="OnSave" Type="Integer" Display="Dynamic"></asp:RangeValidator>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ14_1" runat="server" ControlToValidate="txtQ14_1" TabIndex="87" ValidationGroup="OnSave"
                                            Display="Dynamic" ErrorMessage="* Required field."></asp:RequiredFieldValidator>
                                <asp:TextBox ID="txtQ14_2" runat="server" Text="0" MaxLength="2" Width="25px" TabIndex="88"></asp:TextBox>&nbsp;months
                                <asp:RangeValidator ID="RangeValidatorForQ14_2" runat="server" TabIndex="89" ControlToValidate="txtQ14_2" ErrorMessage="Must be zero or a positive integer."
                                MaximumValue="999" MinimumValue="0" SetFocusOnError="true" ValidationGroup="OnSave" Type="Integer" Display="Dynamic"></asp:RangeValidator>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ14_2" runat="server" ControlToValidate="txtQ14_2" TabIndex="90" ValidationGroup="OnSave"
                                            Display="Dynamic" ErrorMessage="* Required field."></asp:RequiredFieldValidator>
                                <asp:HiddenField ID="HiddenQ14" runat="server" Visible="false" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                15
                            </td>
                            <td>
                                <p>
                                    Approximately how many NON-VA health care visits have you had in the LAST 3 MONTHS for your CURRENT PAIN PROBLEM? Include ALL visits to any
                                    NON-VA health care provider. For example, if you saw a surgeon once, a physical therapist 12 times, and a chiropractor 2 times for reasons 
                                    related to your pain, the total number of visits would be 15.
                                </p>
                                <asp:Label ID="LabelForQ15" runat="server" AssociatedControlID="txtQ15" SkinID="DataLabel" TabIndex="91">
                                </asp:Label>
                                <br />
                                <asp:TextBox ID="txtQ15" runat="server" MaxLength="2" Width="25px" TabIndex="92"></asp:TextBox>
                                <asp:RangeValidator ID="RangeValidatorForQ15" runat="server" TabIndex="93" ControlToValidate="txtQ15" ErrorMessage="Must be zero or a positive integer."
                                MaximumValue="9999" MinimumValue="0" SetFocusOnError="true" ValidationGroup="OnSave" Type="Integer" Display="Dynamic"></asp:RangeValidator>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ15" runat="server" ControlToValidate="txtQ15" TabIndex="94" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Required field."></asp:RequiredFieldValidator>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                16
                            </td>
                            <td>
                                <p>
                                    Approximately how many VA health care visits have you had in the LAST 3 MONTHS for your CURRENT PAIN PROBLEM? Include ALL visits to any VA
                                    health care provider. For example, if you saw a surgeon once, a physical therapist 12 times, and a chiropractor 2 times for reasons related 
                                    to your pain, the total number of visits would be 15.
                                </p>
                                <asp:Label ID="LabelForQ16" runat="server" AssociatedControlID="txtQ16" SkinID="DataLabel" TabIndex="101">
                                </asp:Label>
                                <br />
                                <asp:TextBox ID="txtQ16" runat="server" MaxLength="2" Width="25px" TabIndex="102"></asp:TextBox>
                                <asp:RangeValidator ID="RangeValidatorForQ16" runat="server" TabIndex="104" ControlToValidate="txtQ16" ErrorMessage="Must be zero or a positive integer."
                                MaximumValue="9999" MinimumValue="0" SetFocusOnError="true" ValidationGroup="OnSave" Type="Integer" Display="Dynamic"></asp:RangeValidator>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ16" runat="server" ControlToValidate="txtQ16" TabIndex="105" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Required field."></asp:RequiredFieldValidator>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                17
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ17" runat="server" AssociatedControlID="chbxlstQ17" SkinID="DataLabel" TabIndex="111">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <asp:CheckBoxList ID="chbxlstQ17" runat="server" RepeatColumns="2" RepeatDirection="Vertical" Width="350px" DataSourceID="ObjectDataSourceQ17" TabIndex="112" OnDataBound="onChbxlstQ17DataBound"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:CheckBoxList>
                                <%--<asp:RequiredFieldValidator ID="RequiredFieldValidatorQ17" runat="server" ControlToValidate="rblQ17" TabIndex="113" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>--%>
                                <asp:Label ID="lblErrorQ17" runat="server" CssClass="requiredField" TabIndex="113"></asp:Label>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ17" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ17" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ17" runat="server" Visible="false" Value="17" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                18
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ18" runat="server" AssociatedControlID="rblQ18" SkinID="DataLabel" TabIndex="121">
                                </asp:Label> (0 = not at all / 10 = all the time) <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ18" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ18" TabIndex="122"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ18" runat="server" ControlToValidate="rblQ18" TabIndex="123" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ18" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ18" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ18" runat="server" Visible="false" Value="18" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                19
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ19" runat="server" AssociatedControlID="rblQ19" SkinID="DataLabel" TabIndex="124">
                                </asp:Label> (0 = not at all / 10 = all the time) <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ19" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ19" TabIndex="125"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ19" runat="server" ControlToValidate="rblQ19" TabIndex="126" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ19" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ19" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ19" runat="server" Visible="false" Value="19" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                20
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ20" runat="server" AssociatedControlID="rblQ20" SkinID="DataLabel" TabIndex="131">
                                </asp:Label> (0 = not at all / 10 = all the time) <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ20" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ20" TabIndex="132"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ20" runat="server" ControlToValidate="rblQ20" TabIndex="133" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ20" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ20" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ20" runat="server" Visible="false" Value="20" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                21
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ21" runat="server" AssociatedControlID="rblQ21" SkinID="DataLabel" TabIndex="141">
                                </asp:Label> (0 = not at all / 10 = all the time) <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ21" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ21" TabIndex="142"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ21" runat="server" ControlToValidate="rblQ21" TabIndex="143" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ21" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ21" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ21" runat="server" Visible="false" Value="21" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                22
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ22" runat="server" AssociatedControlID="rblQ22" SkinID="DataLabel" TabIndex="151">
                                </asp:Label> (0 = not at all / 10 = all the time) <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ22" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ22" TabIndex="152"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ22" runat="server" ControlToValidate="rblQ22" TabIndex="153" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ22" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ22" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ22" runat="server" Visible="false" Value="22" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                23
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ23" runat="server" AssociatedControlID="rblQ23" SkinID="DataLabel" TabIndex="157">
                                </asp:Label> (0 = not at all / 10 = all the time) <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ23" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ23" TabIndex="158"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ23" runat="server" ControlToValidate="rblQ23" TabIndex="159" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ23" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ23" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ23" runat="server" Visible="false" Value="23" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                24
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ24" runat="server" AssociatedControlID="rblQ24" SkinID="DataLabel" TabIndex="161">
                                </asp:Label> (0 = not at all / 10 = all the time) <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ24" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ24" TabIndex="162"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ24" runat="server" ControlToValidate="rblQ24" TabIndex="163" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ24" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ24" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ24" runat="server" Visible="false" Value="24" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                25
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ25" runat="server" AssociatedControlID="rblQ25" SkinID="DataLabel" TabIndex="211">
                                </asp:Label> (0 = not at all / 10 = all the time) <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ25" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ25" TabIndex="212"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ25" runat="server" ControlToValidate="rblQ25" TabIndex="213" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ25" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ25" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ25" runat="server" Visible="false" Value="25" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                26
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ26" runat="server" AssociatedControlID="rblQ26" SkinID="DataLabel" TabIndex="214">
                                </asp:Label> (0 = not at all / 10 = all the time) <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ26" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ26" TabIndex="215"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ26" runat="server" ControlToValidate="rblQ26" TabIndex="216" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ26" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ26" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ26" runat="server" Visible="false" Value="26" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                27
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ27" runat="server" AssociatedControlID="rblQ27" SkinID="DataLabel" TabIndex="217">
                                </asp:Label> (0 = significant limitation in basic activities / 10 = can perform vigorous activities without limitation) 
                                <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ27" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ27" TabIndex="218"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ27" runat="server" ControlToValidate="rblQ27" TabIndex="219" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ27" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ27" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ27" runat="server" Visible="false" Value="27" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                28
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ28" runat="server" AssociatedControlID="rblQ28" SkinID="DataLabel" TabIndex="221">
                                </asp:Label> (0 = totally worn out / 10 = most energy ever) <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ28" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ28" TabIndex="222"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ28" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ28" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ28" runat="server" Visible="false" Value="28" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                29
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ29" runat="server" AssociatedControlID="rblQ29" SkinID="DataLabel" TabIndex="229">
                                </asp:Label> (0 = very poor strength and endurance / 10 = very high strength and endurance) <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ29" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ29" TabIndex="230"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ29" runat="server" ControlToValidate="rblQ29" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ29" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ29" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ29" runat="server" Visible="false" Value="29" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                30
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ30" runat="server" AssociatedControlID="rblQ30" SkinID="DataLabel" TabIndex="241">
                                </asp:Label> (0 = not depressed at all / 10 = extremely depressed) <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ30" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ30" TabIndex="242"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ30" runat="server" ControlToValidate="rblQ30" TabIndex="243" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ30" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ30" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ30" runat="server" Visible="false" Value="30" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                31
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ31" runat="server" AssociatedControlID="rblQ31" SkinID="DataLabel" TabIndex="244">
                                </asp:Label> (0 = not anxious at all / 10 = extremely anxious) <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ31" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ31" TabIndex="245"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ31" runat="server" ControlToValidate="rblQ31" TabIndex="246" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ31" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ31" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ31" runat="server" Visible="false" Value="31" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                32
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ32" runat="server" AssociatedControlID="rblQ32" SkinID="DataLabel" TabIndex="247">
                                </asp:Label> (0 = not at all / 10 = all the time) <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ32" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ32" TabIndex="248"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ32" runat="server" ControlToValidate="rblQ32" TabIndex="249" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ32" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ32" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ32" runat="server" Visible="false" Value="32" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                33
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ33" runat="server" AssociatedControlID="rblQ33" SkinID="DataLabel" TabIndex="251">
                                </asp:Label> (0 = not safe at all / 10 = extremely safe) <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ33" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ33" TabIndex="252"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ33" runat="server" ControlToValidate="rblQ33" TabIndex="253" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ33" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ33" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ33" runat="server" Visible="false" Value="33" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                34
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ34" runat="server" AssociatedControlID="rblQ34" SkinID="DataLabel" TabIndex="261">
                                </asp:Label> (0 = not at all / 10 = all the time) <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ34" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ34" TabIndex="262"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ34" runat="server" ControlToValidate="rblQ34" TabIndex="263" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ34" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ34" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ34" runat="server" Visible="false" Value="34" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                35
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ35" runat="server" AssociatedControlID="rblQ35" SkinID="DataLabel" TabIndex="271">
                                </asp:Label> (0 = not at all / 10 = all the time) <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ35" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ35" TabIndex="272"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ35" runat="server" ControlToValidate="rblQ35" TabIndex="273" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ35" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ35" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ35" runat="server" Visible="false" Value="35" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                36
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ36" runat="server" AssociatedControlID="rblQ36" SkinID="DataLabel" TabIndex="281">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ36" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ36" TabIndex="282"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="true" OnSelectedIndexChanged="rblQ36_SelectedIndexChanged">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ36" runat="server" ControlToValidate="rblQ36" TabIndex="283" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ36" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ36" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ36" runat="server" Visible="false" Value="36" />
                            </td>
                        </tr>
                        
                        <asp:PlaceHolder ID="plchldrQ37" runat="server" Visible="false">
                            <tr>
                                <td colspan="100%">
                                    &nbsp;
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    37
                                </td>
                                <td>
                                    <asp:Label ID="LabelForQ37" runat="server" AssociatedControlID="txtQ37" SkinID="DataLabel" TabIndex="284"></asp:Label><br />
                                    <asp:TextBox ID="txtQ37" runat="server" MaxLength="3" Width="25px" TabIndex="285"></asp:TextBox>&nbsp;percent.
                                    <asp:RangeValidator ID="RangeValidatorForQ37" runat="server" TabIndex="286" ControlToValidate="txtQ37" ErrorMessage="Must be zero or a positive integer."
                                    MaximumValue="100" MinimumValue="0" SetFocusOnError="true" ValidationGroup="OnSave" Type="Integer" Display="Dynamic"></asp:RangeValidator>
                                    <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ37" runat="server" ControlToValidate="txtQ37" TabIndex="287" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Required field."></asp:RequiredFieldValidator>
                                </td>
                            </tr>
                        </asp:PlaceHolder>
                        
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                38
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ38" runat="server" AssociatedControlID="rblQ38" SkinID="DataLabel" TabIndex="291">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ38" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ38" TabIndex="292"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ38" runat="server" ControlToValidate="rblQ38" TabIndex="293" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ38" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ38" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ38" runat="server" Visible="false" Value="38" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                39
                            </td>
                            <td>
                                <asp:Label ID="LabelForQ39" runat="server" AssociatedControlID="rblQ39" SkinID="DataLabel" TabIndex="294">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <asp:RadioButtonList ID="rblQ39" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ39" TabIndex="295"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="true" OnSelectedIndexChanged="rblQ39_SelectedIndexChanged">
                                </asp:RadioButtonList>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ39" runat="server" ControlToValidate="rblQ39" TabIndex="296" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ39" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ39" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <asp:HiddenField ID="HiddenQ39" runat="server" Visible="false" Value="39" />
                            </td>
                        </tr>
                        
                        <asp:PlaceHolder ID="plchldrQ40_41" runat="server" Visible="false">
                            <tr>
                                <td colspan="100%">
                                    &nbsp;
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    40
                                </td>
                                <td>
                                    <asp:Label ID="LabelForQ40" runat="server" SkinID="DataLabel" Font-Bold="true" TabIndex="297"></asp:Label>
                                    <br />
                                    <asp:TextBox ID="txtQ40_1" runat="server" Text="0" MaxLength="2" Width="25px" Font-Bold="true" TabIndex="298"></asp:TextBox>&nbsp;years&nbsp;&nbsp;&nbsp;&nbsp;
                                    <asp:RangeValidator ID="RangeValidatorForQ40_1" runat="server" TabIndex="299" ControlToValidate="txtQ40_1" ErrorMessage="Must be zero or a positive integer."
                                    MaximumValue="99" MinimumValue="0" SetFocusOnError="true" ValidationGroup="OnSave" Type="Integer" Display="Dynamic"></asp:RangeValidator>
                                    <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ40_1" runat="server" ControlToValidate="txtQ40_1" TabIndex="300" ValidationGroup="OnSave"
                                            Display="Dynamic" ErrorMessage="* Required field."></asp:RequiredFieldValidator>
                                    <asp:TextBox ID="txtQ40_2" runat="server" Text="0" MaxLength="2" Width="25px" TabIndex="301"></asp:TextBox>&nbsp;months
                                    <asp:RangeValidator ID="RangeValidatorForQ40_2" runat="server" TabIndex="302" ControlToValidate="txtQ40_2" ErrorMessage="Must be zero or a positive integer."
                                    MaximumValue="999" MinimumValue="0" SetFocusOnError="true" ValidationGroup="OnSave" Type="Integer" Display="Dynamic"></asp:RangeValidator>
                                    <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ40_2" runat="server" ControlToValidate="txtQ40_2" TabIndex="303" ValidationGroup="OnSave"
                                            Display="Dynamic" ErrorMessage="* Required field."></asp:RequiredFieldValidator>
                                    <asp:HiddenField ID="HiddenQ40" runat="server" Visible="false" />
                                </td>
                            </tr>
                            <tr>
                                <td colspan="100%">
                                    &nbsp;
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    41
                                </td>
                                <td>
                                    <asp:Label ID="LabelForQ41" runat="server" AssociatedControlID="rblQ41" SkinID="DataLabel" TabIndex="305">
                                    </asp:Label> (0 = no relief / 10 = complete relief) <span class="requiredField">*</span><br />
                                    <asp:RadioButtonList ID="rblQ41" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ41" TabIndex="306"
                                        DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                    </asp:RadioButtonList>
                                    <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ41" runat="server" ControlToValidate="rblQ41" TabIndex="307" ValidationGroup="OnSave"
                                        Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                    <asp:ObjectDataSource ID="ObjectDataSourceQ41" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                        <SelectParameters>
                                            <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                            <asp:ControlParameter ControlID="HiddenQ41" Direction="Input" Name="questionNumber" Type="String" />
                                        </SelectParameters>
                                    </asp:ObjectDataSource>
                                    <asp:HiddenField ID="HiddenQ41" runat="server" Visible="false" Value="41" />
                                </td>
                            </tr>
                        </asp:PlaceHolder>
                        
                        <asp:PlaceHolder ID="plchldrQ42_45" runat="server">
                            <tr>
                                <td colspan="100%">
                                    &nbsp;
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    42
                                </td>
                                <td>
                                    <asp:Label ID="LabelForQ42" runat="server" AssociatedControlID="rblQ42" SkinID="DataLabel" TabIndex="308">
                                    </asp:Label> <span class="requiredField">*</span><br />
                                    <asp:RadioButtonList ID="rblQ42" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ42" TabIndex="309"
                                        DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="true" onselectedindexchanged="rblQ42_SelectedIndexChanged">
                                    </asp:RadioButtonList>
                                    <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ42" runat="server" ControlToValidate="rblQ42" TabIndex="310" ValidationGroup="OnSave"
                                        Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                    <asp:ObjectDataSource ID="ObjectDataSourceQ42" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                        <SelectParameters>
                                            <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                            <asp:ControlParameter ControlID="HiddenQ42" Direction="Input" Name="questionNumber" Type="String" />
                                        </SelectParameters>
                                    </asp:ObjectDataSource>
                                    <asp:HiddenField ID="HiddenQ42" runat="server" Visible="false" Value="42" />
                                </td>
                            </tr>
                        
                            <asp:PlaceHolder ID="plchldrQ43_45" runat="server" Visible="false">
                                <tr>
                                    <td colspan="100%">
                                        &nbsp;
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        43
                                    </td>
                                    <td>
                                        <asp:Label ID="LabelForQ43" runat="server" SkinID="DataLabel" Font-Bold="true" TabIndex="311">
                                        </asp:Label>
                                        <br />
                                        <asp:TextBox ID="txtQ43_1" runat="server" Text="0" MaxLength="2" Width="25px" TabIndex="312"></asp:TextBox>&nbsp;years&nbsp;&nbsp;&nbsp;&nbsp;
                                        <asp:RangeValidator ID="RangeValidatorForQ43_1" runat="server" TabIndex="313" ControlToValidate="txtQ43_1" ErrorMessage="Must be zero or a positive integer."
                                        MaximumValue="99" MinimumValue="0" SetFocusOnError="true" ValidationGroup="OnSave" Type="Integer" Display="Dynamic"></asp:RangeValidator>
                                        <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ43_1" runat="server" ControlToValidate="txtQ43_1" TabIndex="314" ValidationGroup="OnSave"
                                            Display="Dynamic" ErrorMessage="* Required field."></asp:RequiredFieldValidator>
                                        <asp:TextBox ID="txtQ43_2" runat="server" Text="0" MaxLength="2" Width="25px" TabIndex="315"></asp:TextBox>&nbsp;months
                                        <asp:RangeValidator ID="RangeValidatorForQ43_2" runat="server" TabIndex="316" ControlToValidate="txtQ43_2" ErrorMessage="Must be zero or a positive integer."
                                        MaximumValue="999" MinimumValue="0" SetFocusOnError="true" ValidationGroup="OnSave" Type="Integer" Display="Dynamic"></asp:RangeValidator>
                                        <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ43_2" runat="server" ControlToValidate="txtQ43_2" TabIndex="317" ValidationGroup="OnSave"
                                            Display="Dynamic" ErrorMessage="* Required field."></asp:RequiredFieldValidator>
                                        <asp:HiddenField ID="HiddenQ43" runat="server" Visible="false" />
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="100%">
                                        &nbsp;
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        44
                                    </td>
                                    <td>
                                        <asp:Label ID="LabelForQ44" runat="server" SkinID="DataLabel" Font-Bold="true" TabIndex="321">
                                        </asp:Label>
                                        <br />
                                        <asp:TextBox ID="txtQ44_1" runat="server" Text="0" MaxLength="2" Width="25px" TabIndex="322"></asp:TextBox>&nbsp;years&nbsp;&nbsp;&nbsp;&nbsp;
                                        <asp:RangeValidator ID="RangeValidatorForQ44_1" runat="server" TabIndex="323" ControlToValidate="txtQ44_1" ErrorMessage="Must be zero or a positive integer."
                                        MaximumValue="99" MinimumValue="0" SetFocusOnError="true" ValidationGroup="OnSave" Type="Integer" Display="Dynamic"></asp:RangeValidator>
                                        <asp:TextBox ID="txtQ44_2" runat="server" Text="0" MaxLength="2" Width="25px" TabIndex="324"></asp:TextBox>&nbsp;months
                                        <asp:RangeValidator ID="RangeValidatorForQ44_2" runat="server" TabIndex="325" ControlToValidate="txtQ44_2" ErrorMessage="Must be zero or a positive integer."
                                        MaximumValue="999" MinimumValue="0" SetFocusOnError="true" ValidationGroup="OnSave" Type="Integer" Display="Dynamic"></asp:RangeValidator>
                                        <asp:HiddenField ID="HiddenQ44" runat="server" Visible="false" />
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="100%">
                                        &nbsp;
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        45
                                    </td>
                                    <td>
                                        <asp:Label ID="LabelForQ45" runat="server" AssociatedControlID="rblQ45" SkinID="DataLabel" TabIndex="331">
                                        </asp:Label> (0 = no relief / 10 = complete relief) <span class="requiredField">*</span><br />
                                        <asp:RadioButtonList ID="rblQ45" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceQ45" TabIndex="332"
                                            DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                        </asp:RadioButtonList>
                                        <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ45" runat="server" ControlToValidate="rblQ45" TabIndex="333" ValidationGroup="OnSave"
                                            Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                        <asp:ObjectDataSource ID="ObjectDataSourceQ45" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                            <SelectParameters>
                                                <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                                <asp:ControlParameter ControlID="HiddenQ45" Direction="Input" Name="questionNumber" Type="String" />
                                            </SelectParameters>
                                        </asp:ObjectDataSource>
                                        <asp:HiddenField ID="HiddenQ45" runat="server" Visible="false" Value="45" />
                                    </td>
                                </tr>
                            </asp:PlaceHolder>

                        </asp:PlaceHolder>                       
                        
                       
                        <tr>
                            <td colspan="100%">
                                <asp:Label ID="lblSurveyError" runat="server" TabIndex="359" CssClass="requiredField"></asp:Label>
                            </td>
                        </tr>                        

                    </table>
                    
        
                    <!-- End Question Area -->
                    <br />
                </asp:Panel>
                
                <table style="width:800px; margin-left:20px;">
                    <tr>
                        <td style="width: 20px;">
                            &nbsp;
                        </td>
                        <td>
                            <telerik:RadAjaxPanel ID="RadAjaxPanel1" runat="server">
                                <asp:Timer ID="InactiveTimer" Interval="300000" Enabled="true" runat="server" OnTick="InActiveTimer_Tick" />
                            </telerik:RadAjaxPanel>
                            <asp:Button ID="btnSaveSurveyDraft" runat="server" UseSubmitBehavior="true" Text="Save Draft" Width="130px" OnClick="btnSaveSurveyDraft_Click"
                                ValidationGroup="OnSaveDraft" TabIndex="360" />
                            <asp:Button ID="btnSubmitSurvey" runat="server" UseSubmitBehavior="true" Text="Save and Prepare Note" Width="180px" OnClick="btnSubmit_Click"
                                ValidationGroup="OnSave" TabIndex="361" />
                            <asp:Button ID="btnCancelSurvey" runat="server" TabIndex="362" UseSubmitBehavior="false" Text="Cancel" Width="130px" OnClick="btnCancel_Click" />
                        </td>
                    </tr>
                </table>
                
            </ContentTemplate>
        </asp:UpdatePanel>
    </telerik:RadCodeBlock>
</asp:Content>



